<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
require 'db.php'; // Include your database connection

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['user_id'])) {
    $userId = $data['user_id'];
    $fieldsToUpdate = [];
    $params = [];
    
    // Check which fields are provided and build the update query
    if (isset($data['name'])) {
        $fieldsToUpdate[] = "name = ?";
        $params[] = $data['name'];
    }
    if (isset($data['email'])) {
        $fieldsToUpdate[] = "email = ?";
        $params[] = $data['email'];
    }
    if (isset($data['username'])) {
        $fieldsToUpdate[] = "username = ?";
        $params[] = $data['username'];
    }
    if (isset($data['password'])) {
        $fieldsToUpdate[] = "password = ?";
        $params[] = $data['password'];
    }
    if (isset($data['grade'])) {
        $fieldsToUpdate[] = "grade = ?";
        $params[] = $data['grade'];
    }
    if (isset($data['stream_details'])) {
        $fieldsToUpdate[] = "stream_details = ?";
        $params[] = $data['stream_details'];
    }
    if (isset($data['gender'])) {
        $fieldsToUpdate[] = "gender = ?";
        $params[] = $data['gender'];
    }

    // If no fields to update, return an error
    if (empty($fieldsToUpdate)) {
        echo json_encode(['status' => 'error', 'message' => 'No fields to update.']);
        exit;
    }

    // Prepare the SQL statement
    $sql = "UPDATE tbl_adhd_users SET " . implode(", ", $fieldsToUpdate) . " WHERE user_id = ?";
    $params[] = $userId; // Add user_id to the parameters
    $stmt = $conn->prepare($sql);
    
    // Bind parameters dynamically
    $types = str_repeat("s", count($params) - 1) . "i"; // Assuming user_id is an integer
    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Profile updated successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update profile.']);
    }

    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required.']);
}

$conn->close();
?>