<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require 'db.php'; // Include the database connection

$pdo = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);

$selectLatestVideo = "SELECT user_id, video_id, lesson_name, grade FROM tbl_videos ORDER BY video_id DESC LIMIT 1";
$stmt = $pdo->prepare($selectLatestVideo);
$stmt->execute();
$video = $stmt->fetch(PDO::FETCH_ASSOC);

$is_read = 0;

$user_id = $video['user_id'];
$videoId = $video['video_id'];
$lessonName = $video['lesson_name'];
$gradeFetched = $video['grade'];

//select user name from tbl_users
$selectUserName = "SELECT name, username FROM tbl_adhd_users WHERE user_id = ?";
$stmt3 = $pdo->prepare($selectUserName);
$stmt3->execute([$user_id]);
$userName = $stmt3->fetch(PDO::FETCH_ASSOC);
$userNameFetched = $userName['username'];
$nameFetched = $userName['name'];

//notification message
$notificationMessage = "A new lesson $lessonName has been uploaded by Teacher $nameFetched. Please check it out.";

//save notification to database
$saveNotification = "INSERT INTO tbl_notifications (user_id, video_id, lesson_name, grade, name, username, notification_message, is_read) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
$stmt2 = $pdo->prepare($saveNotification);
$stmt2->execute([$user_id, $videoId, $lessonName, $gradeFetched, $nameFetched, $userNameFetched, $notificationMessage, $is_read]);

echo json_encode(['status' => 'success', 'message' => 'Notification sent successfully.']);
?>
