<?php
require_once('db.php');

header('Content-Type: application/json');

$school_id = $_GET['school_id'];

$stmt = $conn->prepare("SELECT class_range_to, stream_details FROM tbl_schools WHERE school_id = ?");
$stmt->bind_param("i", $school_id);
$stmt->execute();

// Fetch the result
$result = $stmt->get_result(); // Get the result set from the executed statement

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc(); // Fetch the associative array
    $classRangeTo = $row['class_range_to']; // Access the class_range_to value
    $stream_details_value = $row['stream_details'];
    //decoding the stream details
    $decodedStreams = json_decode($stream_details_value);
    // Now you can use $classRangeTo as needed
} else {
    // Handle the case where no results are found
    echo json_encode(['status' => 'error', 'message' => 'No class range found for the given school ID.']);
}

$grades = [];

for ($i = 1; $i <= $classRangeTo; $i++) {
    $grades[] = $i; 
}
//send response
// echo json_encode($grades);
echo json_encode(['grades' => $grades, 'stream' => $decodedStreams]);

?>