<?php
header('Content-Type: application/json');
// teacher_save_video.php
require 'db.php'; // Include the database connection

// Get POST data
$youtube_url = $_POST['youtube_url'];
$lesson_name = $_POST['lesson_title'];
$subject = $_POST['subject'];
$youtube_desc = $_POST['lesson_description'];

// Validate input
if (empty($youtube_url) || empty($lesson_name) || empty($subject)) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required']);
    exit;
}

// Insert data into the database
$sql = "INSERT INTO tbl_videos (youtube_url, lesson_name, subject, youtube_desc, user_id ) VALUES (?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssss", $youtube_url, $lesson_name, $subject, $youtube_desc, $user_id);

if ($stmt->execute()) {    
    // echo json_encode(['status' => 'success', 'message' => 'Transcribing Video Now.....']);
    // Include transcribe_video.php directly
    require 'transcribe_video.php';
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save video data']);
}

$stmt->close();
$conn->close();

?>