<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
// Connect to your database
require 'db.php';

// Get POST data
$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

// Validate input
if (empty($username) || empty($password)) {
    $response = [
        'success' => false,
        'message' => 'Username and password are required'
    ];
    echo json_encode($response);
    exit;
}

try {
    // MongoDB query - find one user with the given username
    $usersCollection = $db->tbl_adhd_users;
    $user = $usersCollection->findOne(['username' => $username]);

    if ($user) {
        // Verify password
        if ($password == $user['password']) {
            // Password is correct
            $response = [
                'success' => true,
                'message' => 'Login successful',
                'role' => $user['role'],
                'user_id' => (string)$user['_id'] // MongoDB uses ObjectId, convert to string
            ];
        } else {
            // Password is incorrect
            $response = [
                'success' => false,
                'message' => 'Invalid username or password'
            ];
        }
    } else {
        // User not found
        $response = [
            'success' => false,
            'message' => 'Invalid username or password'
        ];
    }
} catch (Exception $e) {
    // Error handling
    $response = [
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ];
}

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>