<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require 'db.php'; // Include the database connection
require 'vendor/autoload.php'; // Ensure you have Guzzle installed

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

//fetch recently saved video from database
$pdo = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);

// $selectVideoFromDB = "SELECT video_id, youtube_url FROM tbl_video ORDER BY video_id DESC LIMIT 1 ";
$selectVideoFromDB = "SELECT video_id, youtube_url FROM tbl_videos ORDER BY video_id DESC LIMIT 1";
$stmt2 = $pdo->prepare($selectVideoFromDB);
$stmt2->execute();
$video = $stmt2->fetch(PDO::FETCH_ASSOC);

$videoId = $video['video_id'];
$youtubeUrlFetched = $video['youtube_url'];

// Function to extract YouTube Video ID from URL
function extractYouTubeID($url) {
    parse_str(parse_url($url, PHP_URL_QUERY), $query);
    return $query['v'] ?? '';
}
function RealMP3Converter(){
    global $youtubeUrlFetched;

    $curl = curl_init();

    $mbele = "https://www.youtube.com/watch?v";

    $nyuma = extractYouTubeID($youtubeUrlFetched);

    // $URL_ = $mbele."&#61;".$nyuma;

    $data = [
        "url" => $mbele.'='.$nyuma,
        "format" => 'mp3',
        "quality" => 0,
        "callbackurl" => 'https://adhdlearnersapp.dextersolutionsltd.com/callback.php'

    ];
    $encoded_data = json_encode($data, JSON_UNESCAPED_SLASHES);
    curl_setopt_array($curl, array(
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'X-RapidAPI-Host: youtube-to-mp315.p.rapidapi.com',
            'X-RapidAPI-Key: 63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1'
        ),
        CURLOPT_URL => 'https://youtube-to-mp315.p.rapidapi.com/download',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $encoded_data
    ));

    $response = curl_exec($curl);

    // $response_result = json_decode($response->getBody(), true);

    curl_close($curl);
    
    $texters = "Lets see :";
    $data_debugging = array($texters, $encoded_data, $response);
    echo json_encode($data_debugging, JSON_FORCE_OBJECT);
    error_log('JSON Data: ' . $encoded_data);

}

//Tutmie function kutoka documentation
function convertYTMP3() {
    global $youtubeUrlFetched;

    $client = new Client();
    $pass_videoId = extractYouTubeID($youtubeUrlFetched);

    //error_log('YouTube URL: ' . $youtubeUrlFetched);
    //$data_debugging = array($youtubeUrlFetched);
    //echo json_encode($data_debugging, JSON_FORCE_OBJECT);


    if (empty($pass_videoId)) {
        throw new Exception('Invalid YouTube URL or video ID not found');
    }

    $youtubeUrl = 'https://www.youtube.com/watch?v=' . $pass_videoId;

    // $jsonData = [
    //     'url' => $youtubeUrl,
    //     'format' => 'mp3',
    //     'quality' => 0,
    //     'callbackUrl' => 'https://adhdlearnersapp.dextersolutionsltd.com/callback.php'
    // ];

    // Create the JSON payload
    $payload = json_encode([
        'url' => $youtubeUrlFetched,
        'format' => 'mp3',
        'quality' => 0,
        'callbackUrl' => '' // Add your callback URL if needed
    ], JSON_UNESCAPED_SLASHES);

    // $payload = [
    //     'url' => $youtubeUrlFetched,
    //     'format' => 'mp3',
    //     'quality' => 0,
    //     'callbackUrl' => '' // Add your callback URL if needed
    // ];

    //$payloadData = json_encode($payload, JSON_UNESCAPED_SLASHES);

    error_log('JSON Data: ' . json_encode($payload));

    // Make the POST request to the new API
    $response = $client->request('POST', 'https://youtube-to-mp315.p.rapidapi.com/download', [
        'headers' => [
            'X-RapidAPI-Host' => 'youtube-to-mp315.p.rapidapi.com',
            'X-RapidAPI-Key' => '63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1', // RapidAPI key
            'Content-Type' => 'application/json'
        ],
        $payload
    ]);

    // Decode the response
    $result = json_decode($response->getBody(), true);

    

    // Check if the response contains the download link
    if (!isset($result['downloadUrl']) || $result['status'] !== 'AVAILABLE') {
        throw new Exception('Failed to get download link: ' . ($result['msg'] ?? 'Unknown error'));
    }

    // Save the audio link to the database
    $saved_audio_link = $result['downloadUrl'];
    saveAudioLinkToDatabase($saved_audio_link);

    // Optionally, save the audio file to the server
    saveAudioWithGuzzle();

    return $saved_audio_link;
}

function AnotherConverter() {
    global $youtubeUrlFetched;

    // Get the YouTube video ID
    $my_videoId = extractYouTubeID($youtubeUrlFetched);
    
    // Check if we have a valid ID
    if (empty($my_videoId)) {
        return json_encode(["error" => "Invalid YouTube URL or unable to extract video ID"]);
    }

    $client = new Client();

    // Create the JSON body with proper variable interpolation
    $requestBody = json_encode(["videoId" => $my_videoId]);
            
    $response = $client->request('POST', 'https://tube-mp31.p.rapidapi.com/api/json', [
        'body' => $requestBody,
        'headers' => [
            'Content-Type' => 'application/json',
            'x-rapidapi-host' => 'tube-mp31.p.rapidapi.com',
            'x-rapidapi-key' => '63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1',
        ],
    ]);
    
    $responseBody = $response->getBody()->getContents();

    $responseData = json_decode($responseBody, true);
    
    // Set headers for CORS
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST");
    header("Access-Control-Allow-Headers: X-Requested-With");
    header('Content-Type: application/json');
    
    // // For debugging purposes
    // $data_debugging = [
    //     "status" => "success",
    //     "videoId" => $my_videoId,
    //     "response" => $responseBody
    // ];

    // Extract the download URL from the response if available
    if ($responseData && 
        isset($responseData['status']) && 
        $responseData['status'] === 'success' && 
        isset($responseData['result'][0]['dlurl'])) {
        
        $downloadUrl = $responseData['result'][0]['dlurl'];
        $videoTitle = $responseData['result'][0]['title'] ?? 'Unknown';
        
        return $downloadUrl;
        // return json_encode([
        //     "status" => "success",
        //     "videoId" => $my_videoId,
        //     "title" => $videoTitle,
        //     "downloadUrl" => $downloadUrl
        // ], JSON_UNESCAPED_SLASHES);
    } else {
        return json_encode([
            "status" => "error",
            "message" => "Download URL not found in the response",
            "fullResponse" => $responseData
        ]);
    }
    // Save the audio link to the database
    $saved_audio_link = $downloadUrl;
    saveAudioLinkToDatabase($saved_audio_link);

    // Optionally, save the audio file to the server
    saveAudioWithGuzzle();

    return $saved_audio_link;
}

function saveAudioWithGuzzle(){
    //first we fetch our link
    global $pdo;

    $fetchTheAudioLink = "SELECT audio_link, video_id FROM tbl_videos ORDER BY video_id DESC LIMIT 1";
    $audio_stmt2 = $pdo->prepare($fetchTheAudioLink);
    $audio_stmt2->execute();
    $audioLinkerz = $audio_stmt2->fetch(PDO::FETCH_ASSOC);

    $my_audio_link_fetched = $audioLinkerz['audio_link'];
    $my_fetched_video_id = $audioLinkerz['video_id'];

    //the destination where the file goes
    $destinationPath = "audios/audio_". $my_fetched_video_id . ".mp3";

    $client = new Client([
        'timeout' => 180.0,
        'verify' => false,
        'headers' => [
                'x-run' => 'cd3000a58f6e4f2a222201f5ee2bf130',
                // 'User-Agent' => 'Mozilla/5.0 (compatible; MyAudioFetcher/1.0)', // Some servers require this
                'Accept' => 'audio/mpeg, audio/*;q=0.9', // Specify accepted types
            ],
    ]);

    // Get headers first to validate content type and size
    //$headResponse = $client->head($my_audio_link_fetched);
    
    // Optional: Check content type
    // $contentType = $headResponse->getHeaderLine('Content-Type');
    // $allowedTypes = ['audio/mpeg', 'audio/wav', 'audio/ogg'];
    // if (!in_array($contentType, $allowedTypes)) {
    //     return "Invalid audio file type: " . $contentType;
    // }

    // // Optional: Check file size (if provided by server)
    // $contentLength = $headResponse->getHeaderLine('Content-Length');
    // $maxSize = 20 * 1024 * 1024; // 20MB
    // if ($contentLength && $contentLength > $maxSize) {
    //     return "File too large: " . $contentLength . " bytes";
    // }

    // Create directory if it doesn't exist
    $directory = dirname($destinationPath);
    if (!file_exists($directory)) {
        mkdir($directory, 0777, true);
    }

    // Send GET request and save the file directly
    // $response = $client->request('GET', $my_audio_link_fetched, [
    //     'sink' => $destinationPath // This tells Guzzle where to save the file
    // ]);
    $cleanUrl = preg_replace('/^GET\s+/i', '', trim($my_audio_link_fetched));
    $response = $client->get($cleanUrl, [
        'sink' => $destinationPath
    ]);

    // echo json_encode("I am trying to save the audio file".$destinationPath);
    $upt_stmt = $pdo->prepare("UPDATE tbl_videos SET server_audio_link = ? WHERE video_id = ?");
    $upt_stmt->execute([$destinationPath, $my_fetched_video_id]);

    // Check if the request was successful
    if ($response->getStatusCode() === 200) {
        
        return "Audio file saved successfully to " . $destinationPath;
    } else {
        echo json_encode("Our file has not been saved!" . $response->getStatusCode());
        return "Failed to download file. HTTP Status: " . $response->getStatusCode();
    }
    
}

// Modified transcribeAudio function to handle URL downloads
function newTranscribeAudio(){
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $assemblyKey = '8b2e22acc4704d8e8127d8bc360e2072';

    global $pdo;

    $fetchAudioLink = "SELECT server_audio_link, audio_link, video_id FROM tbl_videos ORDER BY video_id DESC LIMIT 1";
    $audio_stmt2 = $pdo->prepare($fetchAudioLink);
    $audio_stmt2->execute();
    $audioLinkers = $audio_stmt2->fetch(PDO::FETCH_ASSOC);

    $audio_link_fetched = $audioLinkers['server_audio_link'];
    $the_video_id_fetched = $audioLinkers['video_id'];
    $remote_audio_link = $audioLinkers['audio_link'];

    $full_audio_pathway = 'https://adhdlearnersapp.dextersolutionsltd.com/'. $audio_link_fetched;

    // AssemblyAI transcript endpoint (where we submit the file)
    $transcript_endpoint = "https://api.assemblyai.com/v2/transcript";

    // Request parameters 
    // $data = array(
    //     "audio_url" => $full_audio_pathway // audio file yetu
    // );
    //pass the remote link now
    // $remote_texters = "Remote URL is: ";
    // $final_remote_link = json_encode($remote_audio_link, JSON_UNESCAPED_SLASHES);
    // $data_debugging = array($remote_texters, $final_remote_link);
    // echo json_encode($data_debugging, JSON_FORCE_OBJECT);
    $data = array(
        "audio_url" => $full_audio_pathway // audio file yetu
    );

    // HTTP request headers
    $headers = array(
        "authorization: 8b2e22acc4704d8e8127d8bc360e2072",
        "content-type: application/json"
    );

    // submit for transcription via HTTP request
    $curl = curl_init($transcript_endpoint);

    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($curl);

    $response = json_decode($response, true);

    curl_close($curl);

    # polling for transcription completion
    $transcript_id = $response['id'];
    $polling_endpoint = "https://api.assemblyai.com/v2/transcript/" . $transcript_id;

    while (true) {
        $polling_response = curl_init($polling_endpoint);

        curl_setopt($polling_response, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($polling_response, CURLOPT_RETURNTRANSFER, true);

        $transcription_result = json_decode(curl_exec($polling_response), true);

        if ($transcription_result['status'] === "completed") {

            //lets debug here
            $remote_texters = "Transcription Text : ";
            //$final_remote_link = json_encode($remote_audio_link, JSON_UNESCAPED_SLASHES);
            $trans_text = $transcription_result['text'];
            $data_debugging = array($remote_texters, $trans_text);
            echo json_encode($data_debugging, JSON_FORCE_OBJECT);

            echo $transcription_result['text'];
            return $transcription_result['text'];
            break;
        } else if ($transcription_result['status'] === "error") {
            throw new Exception("Transcription failed: " . $transcription_result['error']);
        } else {
            sleep(3);
        }
    }

}

function RevAI_transcribe(){
    $token = '02jZoH_Eg_Yhld9h5f3ehv86Mz1L_AZd3NOwBL_hUYp5zUhJVTra0yl6v4KFTjP-sYoyHGuizyOP1lI_CI2alGoSsejRI';
    $fileUrl = 'https://tubemp3.net/dlUrl/aHR0cHM6Ly90ZXN0LmZhYmRsLmNvbS95b3V0dWJlL2Rvd25sb2FkLW1wMy80YjM4MDU3MzNkYjE2YzEyZmU2NmNiMzEyNTgwNjYwNQ==&t=lesson+56&v=WIjfCt48gXg';

    // create client
    $client = new Client([
        'base_uri' => 'https://api.rev.ai/speechtotext/v1/',
        'headers' => ['Authorization' => "Bearer $token"]
    ]);
    $mbele_ = 'https://tubemp3.net/dlUrl/';
    // send POST request and get response body
    $response = $client->request(
        'POST',
        'jobs',
        ['json' => ['source_config' => ['url' => 'https://tubemp3.net/dlUrl/aHR0cHM6Ly90ZXN0LmZhYmRsLmNvbS95b3V0dWJlL2Rvd25sb2FkLW1wMy80YjM4MDU3MzNkYjE2YzEyZmU2NmNiMzEyNTgwNjYwNQ==&t=lesson+56&v=WIjfCt48gXg']]]
    )
    ->getBody()
    ->getContents();

    $remote_texters = "Rev AI is: ";
    //$final_remote_link = json_encode($remote_audio_link, JSON_UNESCAPED_SLASHES);
    $rev_ai_response = json_decode($response);
    $data_debugging = array($remote_texters, $rev_ai_response);
    echo json_encode($data_debugging, JSON_FORCE_OBJECT);

    // decode response JSON and print
    print_r(json_decode($response));
}

function SpicyLaika () {

    global $youtubeUrlFetched;
    $nyuma = extractYouTubeID($youtubeUrlFetched);
    $final_url = 'https://youtube-mp3-audio-video-downloader.p.rapidapi.com/download-mp3/'.$nyuma;
    $ch = curl_init($final_url);
    curl_setopt_array($ch, [
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: youtube-mp3-audio-video-downloader.p.rapidapi.com",
            "x-rapidapi-key: 63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1"
        ],
        CURLOPT_RETURNTRANSFER => true
    ]);
    file_put_contents("audio.mp3", curl_exec($ch));
    curl_close($ch);
}

function SpicyLaika2() {
    global $youtubeUrlFetched;
    global $videoId;
    $nyuma = extractYouTubeID($youtubeUrlFetched);
    $final_url = 'https://youtube-mp3-audio-video-downloader.p.rapidapi.com/download-mp3/'.$nyuma;
    
    // Create folder path
    $folder_path = "audios/";
    
    // Create the directory if it doesn't exist
    if (!file_exists($folder_path)) {
        mkdir($folder_path, 0755, true);
    }
    
    // Generate a more unique filename using the YouTube ID
    $filename = $folder_path . "audio_" . $nyuma . ".mp3";
    
    $ch = curl_init($final_url);
    curl_setopt_array($ch, [
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: youtube-mp3-audio-video-downloader.p.rapidapi.com",
            "x-rapidapi-key: 63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1"
        ],
        CURLOPT_RETURNTRANSFER => true
    ]);
    
    $result = curl_exec($ch);
    
    if ($result === false) {
        // Handle curl error
        return ["error" => curl_error($ch)];
    }
    
    // Save the file and check if it was successful
    if (file_put_contents($filename, $result) === false) {
        return ["error" => "Failed to save file"];
    }
    
    curl_close($ch);

    $remote_texters = "Spicy Laika is: ";
    //$final_remote_link = json_encode($remote_audio_link, JSON_UNESCAPED_SLASHES);
    $rev_ai_response = json_decode($filename);
    $data_debugging = array($remote_texters, $rev_ai_response);
    echo json_encode($data_debugging, JSON_FORCE_OBJECT);

    //naeka file path kwa server
    global $pdo;
    $upt_stmt = $pdo->prepare("UPDATE tbl_videos SET server_audio_link = ? WHERE video_id = ?");
    $upt_stmt->execute([$filename, $videoId]);
    
    return ["success" => true, "file_path" => $filename];
}


// Step 3: Summarize the transcript using OpenAI GPT API
// function summarizeText($text) {
//     $client = new Client();
//     $apiKey = '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';
    
//     $response = $client->request('POST', 'https://api.openai.com/v1/chat/completions', [
//         'headers' => [
//             'Authorization' => 'Bearer ' . $apiKey,
//             'Content-Type' => 'application/json'
//         ],
//         'json' => [
//             'model' => 'whisper-1',f
//             'messages' => [['role' => 'user', 'content' => 'Summarize this transcript: ' . $text]],
//             'temperature' => 0.7
//         ]
//     ]);
    
//     return json_decode($response->getBody(), true)['choices'][0]['message']['content'] ?? '';
// }

// Lets try to use Cohere for our summary
function summarizeText($text) {
    $client = new Client();
    $apiKey = 'jo1Ihz9lxKrGyIvvUaRJMCPRO0IAhWiFYO59B6ft';

    $response = $client->request('POST', 'https://api.cohere.ai/v1/summarize', [
        'headers' => [
            'Authorization' => 'Bearer ' . $apiKey,
            'Content-Type' => 'application/json'
        ],
        'json' => [
            'text' => $text,
            'length' => 'medium', // Options: short, medium, long
            'format' => 'paragraph'
        ]
    ]);

    return json_decode($response->getBody(), true)['summary'] ?? '';
}

// Step 4: Save to MySQL database
function saveToDatabase($videoFetchedID, $videoUrl, $transcript, $summary) {
    global $pdo;
    $stmt = $pdo->prepare("INSERT INTO video_transcriptions (video_id, video_url, transcript, summary) VALUES (?, ?, ?, ?)");
    return $stmt->execute([$videoFetchedID, $videoUrl, $transcript, $summary]);
}

// Step 4: Save to MySQL database
function saveAudioLinkToDatabase($audioLink) {
    global $pdo;
    global $videoId;

    $upt_stmt = $pdo->prepare("UPDATE tbl_videos SET audio_link = ? WHERE video_id = ?");
    return $upt_stmt->execute([$audioLink, $videoId]);
}

// Main execution
$videoID = $videoId;


//Tuanze by converting the youtube video to MP3
// $mp3TrueUrl = convertYTMP3($youtubeUrlFetched);
// $mp3TrueUrl = convertYTMP3();
// $mp3TrueUrl = AnotherConverter();
// $mp3TrueUrl = toMP3Audio();
$mp3TrueUrl = SpicyLaika2();
// $mp3TrueUrl = RevAI_transcribe();

// var_dump($mp3Url);
if ($mp3TrueUrl) {
    // $transcript = transcribeAudio($mp3TrueUrl);
    global $youtubeUrlFetched;
    global $videoId;
    
    //alafu tumake transcript ya io audio
    $transcript = newTranscribeAudio();
    
    //kumalizia ni ku create summary ya audio
    $summary = summarizeText($transcript);

    if (saveToDatabase($videoId, $youtubeUrlFetched, $transcript, $summary)) {
        echo "Transcription and Summary Saved Successfully.";
    } else {
        echo "Failed to save data.";
    }
} else {
    echo "Failed to fetch MP3.";
}
?>