<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require 'db.php'; // Include the database connection
require 'vendor/autoload.php'; // Ensure you have Guzzle installed

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

// Fetch recently saved video from database
try {
    // Get videos collection
    $videosCollection = $db->tbl_videos;
    
    // Find the most recent video
    $video = $videosCollection->findOne(
        [], // empty filter to match all documents
        [
            'sort' => ['_id' => -1],
            'limit' => 1
        ]
    );
    
    if (!$video) {
        throw new Exception('No videos found in the database');
    }
    
    $videoId = (string)$video['_id']; // MongoDB uses ObjectId, convert to string
    $youtubeUrlFetched = $video['youtube_url'];
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to fetch video: ' . $e->getMessage()]);
    exit;
}

// Function to extract YouTube Video ID from URL
function extractYouTubeID($url) {
    parse_str(parse_url($url, PHP_URL_QUERY), $query);
    return $query['v'] ?? '';
}

// Modified transcribeAudio function to handle URL downloads
function newTranscribeAudio(){
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $assemblyKey = '8b2e22acc4704d8e8127d8bc360e2072';

    global $db;
    global $videoId;

    try {
        // Get the most recent video from MongoDB
        $videosCollection = $db->tbl_videos;
        $video = $videosCollection->findOne(
            ['_id' => $videoId],
            ['projection' => ['server_audio_link' => 1, 'audio_link' => 1]]
        );

        if (!$video) {
            throw new Exception('Video not found');
        }

        $audio_link_fetched = $video['server_audio_link'] ?? '';
        $remote_audio_link = $video['audio_link'] ?? '';
        
        $full_audio_pathway = 'https://adhdlearnersapp.dextersolutionsltd.com/'. $audio_link_fetched;

        // AssemblyAI transcript endpoint (where we submit the file)
        $transcript_endpoint = "https://api.assemblyai.com/v2/transcript";

        $data = array(
            "audio_url" => $full_audio_pathway // audio file yetu
        );

        // HTTP request headers
        $headers = array(
            "authorization: 8b2e22acc4704d8e8127d8bc360e2072",
            "content-type: application/json"
        );

        // submit for transcription via HTTP request
        $curl = curl_init($transcript_endpoint);

        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curl);

        $response = json_decode($response, true);

        curl_close($curl);

        # polling for transcription completion
        $transcript_id = $response['id'];
        $polling_endpoint = "https://api.assemblyai.com/v2/transcript/" . $transcript_id;

        while (true) {
            $polling_response = curl_init($polling_endpoint);

            curl_setopt($polling_response, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($polling_response, CURLOPT_RETURNTRANSFER, true);

            $transcription_result = json_decode(curl_exec($polling_response), true);

            if ($transcription_result['status'] === "completed") {
                return $transcription_result['text'];
                break;
            } else if ($transcription_result['status'] === "error") {
                throw new Exception("Transcription failed: " . $transcription_result['error']);
            } else {
                sleep(3);
            }
        }
    } catch (Exception $e) {
        error_log('Transcription error: ' . $e->getMessage());
        return '';
    }
}

function SpicyLaika2() {
    global $youtubeUrlFetched;
    global $videoId;
    global $db;
    
    $nyuma = extractYouTubeID($youtubeUrlFetched);
    $final_url = 'https://youtube-mp3-audio-video-downloader.p.rapidapi.com/download-mp3/'.$nyuma;
    
    // Create folder path
    $folder_path = "audios/";
    
    // Create the directory if it doesn't exist
    if (!file_exists($folder_path)) {
        mkdir($folder_path, 0755, true);
    }
    
    // Generate a more unique filename using the YouTube ID
    $filename = $folder_path . "audio_" . $nyuma . ".mp3";
    
    $ch = curl_init($final_url);
    curl_setopt_array($ch, [
        CURLOPT_HTTPHEADER => [
            "x-rapidapi-host: youtube-mp3-audio-video-downloader.p.rapidapi.com",
            "x-rapidapi-key: 63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1"
        ],
        CURLOPT_RETURNTRANSFER => true
    ]);
    
    $result = curl_exec($ch);
    
    if ($result === false) {
        // Handle curl error
        return ["error" => curl_error($ch)];
    }
    
    // Save the file and check if it was successful
    if (file_put_contents($filename, $result) === false) {
        return ["error" => "Failed to save file"];
    }
    
    curl_close($ch);

    // Update server_audio_link in MongoDB
    try {
        $videosCollection = $db->tbl_videos;
        $updateResult = $videosCollection->updateOne(
            ['_id' => $videoId],
            ['$set' => ['server_audio_link' => $filename]]
        );
        
        if ($updateResult->getModifiedCount() == 0) {
            error_log('Failed to update audio link in database');
        }
    } catch (Exception $e) {
        error_log('MongoDB update error: ' . $e->getMessage());
    }
    
    return ["success" => true, "file_path" => $filename];
}


// Lets try to use Cohere for our summary
function summarizeText($text) {
    $client = new Client();
    $apiKey = 'jo1Ihz9lxKrGyIvvUaRJMCPRO0IAhWiFYO59B6ft';

    $response = $client->request('POST', 'https://api.cohere.ai/v1/summarize', [
        'headers' => [
            'Authorization' => 'Bearer ' . $apiKey,
            'Content-Type' => 'application/json'
        ],
        'json' => [
            'text' => $text,
            'length' => 'medium', // Options: short, medium, long
            'format' => 'paragraph'
        ]
    ]);

    return json_decode($response->getBody(), true)['summary'] ?? '';
}

// Save to MongoDB database
function saveToDatabase($videoFetchedID, $videoUrl, $transcript, $summary) {
    global $db;
    
    try {
        // Insert into video_transcriptions collection
        $transcriptionsCollection = $db->video_transcriptions;
        
        $result = $transcriptionsCollection->insertOne([
            'video_id' => $videoFetchedID,
            'video_url' => $videoUrl,
            'transcript' => $transcript,
            'summary' => $summary,
            'created_at' => new DateTime()
        ]);
        
        return $result->getInsertedCount() > 0;
    } catch (Exception $e) {
        error_log('MongoDB saveToDatabase error: ' . $e->getMessage());
        return false;
    }
}


// Main execution
$videoID = $videoId;

// Convert the youtube video to MP3
$mp3TrueUrl = SpicyLaika2();

if ($mp3TrueUrl) {
    // Transcribe the audio
    $transcript = newTranscribeAudio();
    
    // Create summary of audio
    $summary = summarizeText($transcript);

    if (saveToDatabase($videoId, $youtubeUrlFetched, $transcript, $summary)) {
        echo "Transcription and Summary Saved Successfully.";
    } else {
        echo "Failed to save data.";
    }
} else {
    echo "Failed to fetch MP3.";
}
?>