<?php
header('Content-Type: application/json');
// teacher_save_video.php
require 'db.php'; // Include the database connection

// Get POST data
$youtube_url = $_POST['youtube_url'];
$lesson_name = $_POST['lesson_title'];
$subject = $_POST['subject'];
$youtube_desc = $_POST['lesson_description'];
$user_id = "2"; // In production, this should come from session/auth

// Validate input
if (empty($youtube_url) || empty($lesson_name) || empty($subject)) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required']);
    exit;
}

try {
    // Insert data into MongoDB
    $videosCollection = $db->tbl_videos;
    
    $result = $videosCollection->insertOne([
        'youtube_url' => $youtube_url,
        'lesson_name' => $lesson_name,
        'subject' => $subject,
        'youtube_desc' => $youtube_desc,
        'user_id' => $user_id,
        'created_at' => new DateTime()
    ]);
    
    if ($result->getInsertedCount() > 0) {
        // Store the ID for use in transcribe_video.php
        $GLOBALS['videoId'] = (string)$result->getInsertedId();
        
        // Include transcribe_video.php directly
        require 'transcribe_video.php';
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to save video data']);
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>