<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Database configuration
require_once('db.php');

// Get parameters from the request
$user_id = $_GET['user_id'] ?? null;
$role = $_GET['role'] ?? null;

if (!$user_id || !$role) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User ID and role are required'
    ]);
    exit;
}

try {
    if ($role === 'teacher') {
        // For teachers, show only their own videos
        $videosCollection = $db->tbl_videos;
        $videos = $videosCollection->find(
            ['user_id' => $user_id],
            [
                'projection' => [
                    'video_url' => 1,
                    'subject' => 1,
                    'summary' => 1,
                    'lesson_name' => 1
                ],
                'sort' => ['_id' => -1]
            ]
        )->toArray();
        
    } else if ($role === 'student') {
        // For students, show videos from teachers in their school
        // First get the student's school_id
        $usersCollection = $db->tbl_adhd_users;
        $student = $usersCollection->findOne(
            ['_id' => $user_id],
            ['projection' => ['school_id' => 1]]
        );
        
        if (!$student || !isset($student['school_id'])) {
            throw new Exception('Student information not found');
        }
        
        // Find all teachers in the same school
        $teachers = $usersCollection->find(
            [
                'school_id' => $student['school_id'],
                'role' => 'teacher'
            ],
            ['projection' => ['_id' => 1]]
        )->toArray();
        
        $teacherIds = array_map(function($teacher) {
            return $teacher['_id'];
        }, $teachers);
        
        // Get videos from these teachers
        $videosCollection = $db->tbl_videos;
        $videos = $videosCollection->find(
            ['user_id' => ['$in' => $teacherIds]],
            [
                'projection' => [
                    'video_url' => 1,
                    'subject' => 1,
                    'summary' => 1,
                    'lesson_name' => 1
                ],
                'sort' => ['_id' => -1]
            ]
        )->toArray();
        
    } else {
        throw new Exception('Invalid role specified');
    }
    
    // Format the results for consistency
    $formattedVideos = [];
    foreach ($videos as $video) {
        $formattedVideos[] = [
            'video_id' => (string)$video['_id'],
            'video_url' => $video['video_url'] ?? '',
            'subject' => $video['subject'] ?? '',
            'summary' => $video['summary'] ?? '',
            'lesson_name' => $video['lesson_name'] ?? ''
        ];
    }

    // Return the videos as JSON
    echo json_encode([
        'status' => 'success',
        'data' => $formattedVideos
    ]);

} catch(Exception $e) {
    // Handle errors
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}
?> 