<?php
header('Content-Type: application/json');

// Include database connection
require_once('db.php');

// Get video_id from request
$video_id = isset($_GET['video_id']) ? $_GET['video_id'] : '';

if (empty($video_id)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid video ID'
    ]);
    exit;
}

try {
    // Get the transcript from MongoDB
    $transcriptionsCollection = $db->video_transcriptions;
    
    $transcript = $transcriptionsCollection->findOne(
        ['video_id' => $video_id],
        ['projection' => ['transcript' => 1]]
    );
    
    if ($transcript && isset($transcript['transcript'])) {
        echo json_encode([
            'status' => 'success',
            'transcript' => $transcript['transcript']
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Transcript not found for this video'
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?> 