<?php
header('Content-Type: application/json');

// Include database connection
require_once('db.php');

try {
    // Get video transcriptions collection
    $transcriptionsCollection = $db->video_transcriptions;
    
    // Get videos collection
    $videosCollection = $db->tbl_videos;
    
    // Use MongoDB aggregation to join collections (similar to SQL join)
    $pipeline = [
        [
            '$lookup' => [
                'from' => 'tbl_videos',
                'localField' => 'video_id',
                'foreignField' => '_id',
                'as' => 'video_details'
            ]
        ],
        [
            '$unwind' => '$video_details'
        ],
        [
            '$project' => [
                'video_id' => 1,
                'summary' => 1,
                'transcript' => 1,
                'lesson_name' => '$video_details.lesson_name',
                'subject' => '$video_details.subject'
            ]
        ]
    ];
    
    $cursor = $transcriptionsCollection->aggregate($pipeline);
    $notes = [];
    
    foreach ($cursor as $document) {
        $notes[] = [
            'video_id' => (string)$document['video_id'],
            'lesson_name' => $document['lesson_name'] ?? '',
            'subject' => $document['subject'] ?? '',
            'summary' => $document['summary'] ?? '',
            'transcript' => $document['transcript'] ?? ''
        ];
    }
    
    echo json_encode([
        'status' => 'success',
        'data' => $notes
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch notes: ' . $e->getMessage()
    ]);
}
?> 