<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require 'db.php'; // Include the database connection
require 'vendor/autoload.php'; // Ensure you have Guzzle installed

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

// Fetch the most recently saved video from database
try {
    // Get videos collection
    $videosCollection = $db->tbl_videos;
    
    // Find the most recent video (sort by _id in descending order and limit to 1)
    $video = $videosCollection->findOne(
        [], // empty filter to match all documents
        [
            'sort' => ['_id' => -1],
            'limit' => 1
        ]
    );
    
    if (!$video) {
        throw new Exception('No videos found in the database');
    }
    
    $videoId = (string)$video['_id']; // MongoDB uses ObjectId, convert to string
    $youtubeUrlFetched = $video['youtube_url'];
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to fetch video: ' . $e->getMessage()]);
    exit;
}

// Function to extract YouTube Video ID from URL
function extractYouTubeID($url) {
    parse_str(parse_url($url, PHP_URL_QUERY), $query);
    return $query['v'] ?? '';
}

//Tutmie function kutoka documentation
// Step 2: Transcribe using OpenAI Whisper API
function convertYTMP3($videoUrl) {

    $client = new Client();
    $pass_videoId = extractYouTubeID($videoUrl);
    
    if (empty($pass_videoId)) {
        throw new Exception('Invalid YouTube URL or video ID not found');
    }

    try {
        // First API call to start conversion
        $response = $client->request('GET', 'https://youtube-mp36.p.rapidapi.com/dl', [
            'headers' => [
                // 'x-run' => 'cd3000a58f6e4f2a222201f5ee2bf130',
                'X-RapidAPI-Host' => 'youtube-mp36.p.rapidapi.com',
                'X-RapidAPI-Key' => '63073389demshc2855675fcc3bb7p131e20jsn3c474ad5e1a1'  // Using your existing RapidAPI key
            ],
            'query' => ['id' => $pass_videoId]
        ]);

        $result = json_decode($response->getBody(), true);
        // $data_debugging = array($result);
        // echo json_encode($data_debugging, JSON_FORCE_OBJECT);

        if (!isset($result['link']) || $result['status'] !== 'ok') {
            throw new Exception('Failed to get download link: ' . ($result['msg'] ?? 'Unknown error'));
        }
        $saved_audio_link = $result['link'];
        saveAudioLinkToDatabase($saved_audio_link);
        // saveAudioFileToServer();
        saveAudioWithGuzzle();
        return $result['link'];

    } catch (Exception $e) {
        error_log('YouTube MP3 conversion error: ' . $e->getMessage());
        
        // Try alternate API if first one fails
        try {
            $response = $client->request('GET', 'https://youtube-mp3-downloader2.p.rapidapi.com/ytmp3/ytmp3/', [
                'headers' => [
                    'X-RapidAPI-Host' => 'youtube-mp3-downloader2.p.rapidapi.com',
                    'X-RapidAPI-Key' => '1ee1f7c2d1mshf987dcf39adadf1p1f7472jsn08993f718d3f'
                ],
                'query' => [
                    'url' => 'https://www.youtube.com/watch?v=' . $pass_videoId
                ]
            ]);

            $result = json_decode($response->getBody(), true);

            if (!isset($result['link'])) {
                throw new Exception('Failed to get download link from backup API');
            }

            return $result['link'];

        } catch (Exception $backupError) {
            error_log('Backup API error: ' . $backupError->getMessage());
            return null;
        }
    }
}

// Main execution
$videoID = $videoId;


//Tuanze by converting the youtube video to MP3
// $mp3TrueUrl = convertYTMP3($youtubeUrlFetched);
$mp3TrueUrl = convertYTMP3($youtubeUrlFetched);

// var_dump($mp3Url);
if ($mp3TrueUrl) {
    // $transcript = transcribeAudio($mp3TrueUrl);
    
    //alafu tumake transcript ya io audio
    $transcript = newTranscribeAudio();
    
    //kumalizia ni ku create summary ya audio
    $summary = summarizeText($transcript);

    if (saveToDatabase($videoID, $youtubeUrl, $transcript, $summary)) {
        echo "Transcription and Summary Saved Successfully.";
    } else {
        echo "Failed to save data.";
    }
} else {
    echo "Failed to fetch MP3.";
}
?>