<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

// Database configuration
require_once('db.php');

// Get the user_id from the request
$user_id = $_GET['user_id'] ?? null;

if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Teacher ID is required'
    ]);
    exit;
}

try {
    // Create database connection
    $conn = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Prepare and execute query with user_id filter
    $stmt = $conn->prepare("SELECT video_id, video_url, subject, summary, lesson_name FROM tbl_videos WHERE user_id = ?");
    $stmt->execute([$user_id]);
    
    $videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($videos) {
        // Return the videos as JSON
        echo json_encode([
            'status' => 'success',
            'data' => $videos
        ]);
    } else {
        // No videos found
        echo json_encode([
            'status' => 'error',
            'message' => 'No videos found'
        ]);
    }

} catch(PDOException $e) {
    // Handle database errors
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    // Handle other errors
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

// Close the connection
$conn = null;
$stmt = null;
?> 