<?php
require 'db.php'; // Include your database connection

header('Content-Type: application/json');

if (isset($_GET['user_id'])) {
    $userId = $_GET['user_id'];

    // Prepare the SQL statement to prevent SQL injection
    $stmt = $conn->prepare("SELECT name, email, username, password, grade, stream_details, gender FROM tbl_adhd_users WHERE user_id = ?");
    $stmt->bind_param("i", $userId); // Assuming user_id is an integer

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $teacher = $result->fetch_assoc();
            echo json_encode($teacher);
        } else {
            echo json_encode(['error' => 'No user found with this ID.']);
        }
    } else {
        echo json_encode(['error' => 'Failed to execute query.']);
    }

    $stmt->close();
} else {
    echo json_encode(['error' => 'User ID is required.']);
}

$conn->close();
?>