<?php 
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require 'db.php'; // Include the database connection

$pdo = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);

$grade = $_GET['grade'];

$unreadNotifications = [];
$notificationIds = [];

// Select the latest notification from tbl_notifications
$selectLatestNotification = "SELECT * FROM tbl_notifications WHERE grade = ? AND is_read = 0 ORDER BY notification_id DESC LIMIT 1";
$stmt = $pdo->prepare($selectLatestNotification);
$stmt->execute([$grade]);
$notification = $stmt->fetch(PDO::FETCH_ASSOC);

// If notification is found, add to the arrays
if ($notification) {
    $unreadNotifications[] = $notification['notification_message'];
    $notificationIds[] = $notification['notification_id'];
}

// If there are unread notifications, send to user app and update
if ($unreadNotifications) {
    echo json_encode(['status' => 'success', 'message' => 'Notification is not read', 'notification' => $unreadNotifications]);
    
    // Update all notifications to read
    if (!empty($notificationIds)) {
        $placeholders = implode(',', array_fill(0, count($notificationIds), '?'));
        $updateNotificationRead = "UPDATE tbl_notifications SET is_read = 1 WHERE notification_id IN ($placeholders)";
        $stmt3 = $pdo->prepare($updateNotificationRead);
        $stmt3->execute($notificationIds);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Notification is read', 'notification' => $unreadNotifications]);
    
    // Update all notifications to read
    if (!empty($notificationIds)) {
        $placeholders = implode(',', array_fill(0, count($notificationIds), '?'));
        $updateNotificationRead = "UPDATE tbl_notifications SET is_read = 1 WHERE notification_id IN ($placeholders)";
        $stmt3 = $pdo->prepare($updateNotificationRead);
        $stmt3->execute($notificationIds);
    }
}
?>