<?php 
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require 'db.php'; // Include the database connection

$pdo = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);

$grade = $_GET['grade'];

//select all notifications from tbl_notifications
$selectAllNotifications = "SELECT * FROM tbl_notifications WHERE grade = ? ORDER BY notification_id DESC";
$stmt = $pdo->prepare($selectAllNotifications);
$stmt->execute([$grade]);
$notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);

$notificationsFetched = [];
$teacherName = [];
$lessonName = [];

foreach ($notifications as $notification) {
    $notificationsFetched[] = $notification['notification_message'];
    $teacherName[] = $notification['name'];
    $lessonName[] = $notification['lesson_name'];
}

//return the notifications
echo json_encode(['status' => 'success', 'message' => 'Notifications fetched successfully', 'notifications' => $notificationsFetched, 'teacherName' => $teacherName, 'lessonName' => $lessonName]);

?>